/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractQueryContext;
import com.mckoi.database.FunctionLookup;
import com.mckoi.database.SimpleTransaction;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionSystem;

final class SystemQueryContext
extends AbstractQueryContext {
    private TransactionSystem system;
    private SimpleTransaction transaction;
    private String current_schema;

    SystemQueryContext(SimpleTransaction transaction, String current_schema) {
        this.transaction = transaction;
        this.system = transaction.getSystem();
        this.current_schema = current_schema;
    }

    public TransactionSystem getSystem() {
        return this.system;
    }

    public FunctionLookup getFunctionLookup() {
        return this.getSystem().getFunctionLookup();
    }

    public long nextSequenceValue(String name) {
        TableName tn = this.transaction.resolveToTableName(this.current_schema, name, this.system.ignoreIdentifierCase());
        return this.transaction.nextSequenceValue(tn);
    }

    public long currentSequenceValue(String name) {
        TableName tn = this.transaction.resolveToTableName(this.current_schema, name, this.system.ignoreIdentifierCase());
        return this.transaction.lastSequenceValue(tn);
    }

    public void setSequenceValue(String name, long value) {
        TableName tn = this.transaction.resolveToTableName(this.current_schema, name, this.system.ignoreIdentifierCase());
        this.transaction.setSequenceValue(tn, value);
    }

    public long nextUniqueID(String table_name) {
        TableName tname = TableName.resolve(this.current_schema, table_name);
        return this.transaction.nextUniqueID(tname);
    }

    public String getUserName() {
        return "@SYSTEM";
    }
}

